/************************************************************
 * GlassWindow - an open Black Glass look for widgetmaking. *
 *    Created by Michael Bleigh (mbleigh@cc.gatech.edu)     *
 *               Version 1.0.1 - 23/8/2005                  *
 * Minor changes by Harry Whitfield (g6auc@arrl.net)        *
 *               Version 1.0.x - 12/8/2005 - 19/1/2007      *
 *               Added appendChild() calls 27/2/2008        *
 ************************************************************/

function GlassWindow(folder, parent, width, height, zOrder, colorize) {

	eprint('GlassWindow', folder, parent, width, height, zOrder, colorize);
	
    this.images = [];
    
    if (parent !== undefined)	// parent parameter is present
    {
    	if (width  !== undefined) { this.width  = width;  } else { this.width  = parent.width; }
    	if (height !== undefined) { this.height = height; } else { this.height = parent.height; }
    }
    else // no parameters - assume main window
    {
    	this.width  = 60;
    	this.height = 60;
    }

    this.vOffset = 0;
    this.hOffset = 0;
    this.opacity = 255;
    this.fading = false;
    this.moving = false;
    this.scaling = false;
    this.colorize = colorize;
    
    for (var i = 0; i < 9; i += 1) {
        this.images.push(new Image());
    }
    
    // Populate with the images we want.
    this.images[0].src = folder + "/topleft.png";
    this.images[1].src = folder + "/top.png";
    this.images[2].src = folder + "/topright.png";
    this.images[3].src = folder + "/right.png"; // width: 7
    this.images[4].src = folder + "/bottomright.png";
    this.images[5].src = folder + "/bottom.png";
    this.images[6].src = folder + "/bottomleft.png";
    this.images[7].src = folder + "/left.png"; // width: 7
    this.images[8].src = folder + "/background.png";
    
    if (parent !== undefined) {
        for (i = 0; i < 9; i += 1) {
            parent.appendChild(this.images[i]);		// was this.images[i].window = parent.window;
        }}
    
    if (zOrder !== undefined) {
        for (i = 0; i < 9; i += 1) {
            this.images[i].zOrder = zOrder;
        }}

    if (colorize !== undefined) {
        for (i = 0; i < 9; i += 1) {
            this.images[i].colorize = colorize;
        }}

    this.updatePosition = function() {
        if (this.width < 60) {
            this.width = 60;
        }
        
        if (this.height < 60) {
            this.height = 60;
        }
        
        // Moves the top left corner.
        this.images[0].hOffset = this.hOffset;
        this.images[0].vOffset = this.vOffset;
        
        // Moves and sizes the top
        this.images[1].hOffset = this.hOffset + 30;
        this.images[1].vOffset = this.vOffset;
        this.images[1].width = this.width - 60;
        
        // Moves the top right corner.
        this.images[2].hOffset = this.hOffset + this.width - 30;
        this.images[2].vOffset = this.vOffset;
        
        // Moves and sizes the right border.
        this.images[3].hOffset = this.hOffset + this.width - 8;
        this.images[3].vOffset = this.vOffset + 30;
        this.images[3].height = this.height - 60;
        
        // Moves the bottom right corner.
        this.images[4].hOffset = this.hOffset + this.width - 30;
        this.images[4].vOffset = this.vOffset + this.height - 30;
        
        // Moves and sizes the bottom border.
        this.images[5].hOffset = this.hOffset + 30;
        this.images[5].vOffset = this.vOffset + this.height - 30;
        this.images[5].width = this.width - 60;
        
        // Moves the bottom left corner
        this.images[6].hOffset = this.hOffset;
        this.images[6].vOffset = this.vOffset + this.height - 30;
        
        // Moves and sizes the left border.
        this.images[7].hOffset = this.hOffset;
        this.images[7].vOffset = this.vOffset + 30;
        this.images[7].height = this.height - 60;
        
        // Moves and sizes the background
        this.images[8].hOffset = this.hOffset + 7;
        this.images[8].vOffset = this.vOffset + 30;
        this.images[8].width = this.width - 15;
        this.images[8].height = this.height - 60;
    };
    
    this.setOpacity = function(newOpacity) {
        this.opacity = newOpacity;
        for (i = 0; i < 9; i += 1) {
            this.images[i].opacity = "" + newOpacity;
        }
    };
    
    this.setPosition = function(x, y) {
        this.hOffset = x;
        this.vOffset = y;
        this.updatePosition();
    };
    
    this.setDimension = function(w, h) {
        this.width = w;
        this.height = h;
        this.updatePosition();
    };
    
    this.setColorize = function(newColorize) {
        this.colorize = newColorize;
        for (i = 0; i < 9; i += 1) {
            this.images[i].colorize = newColorize;
        }
    };

    this.update = function() {
        if (this.images[0].opacity != this.opacity) {
            this.setOpacity(this.opacity);
        }
        
        if (this.images[0].hOffset != this.hOffset ||
            this.images[0].vOffset != this.vOffset) {
            this.setPosition(this.hOffset, this.vOffset);    
        }
        
        if (this.images[1].width != this.width - 60 ||
            this.images[3].height != this.height - 60) {
            this.setDimension(this.width, this.height);    
        }
        
        if (this.images[0].colorize != this.colorize) {
            this.setColorize(this.colorize);
        }
    };
    
    this.moveTo = function(x, y, interval) {
        this.moving = true;
        this.fromX = this.hOffset;
        this.fromY = this.vOffset;
        this.toX = x;
        this.toY = y;
        this.moveInterval = interval / 10;
        eprint("Moving from (" + this.fromX + ", " + this.fromY + ") to (" + this.toX + ", " + this.toY + ")");
    };
    
    this.fade = function(from, to, interval) {
        this.fading = true;
        this.fromOpacity = from;
        this.toOpacity = to;
        this.opacity = this.fromOpacity;
        this.fadeInterval = interval / 10;
        eprint("Fading from " + this.fromOpacity + " to " + this.toOpacity);
    };
    
    this.scaleTo = function(w, h, interval) {
        this.scaling = true;
        this.fromWidth = this.width;
        this.toWidth = w;
        this.fromHeight = this.height;
        this.toHeight = h;
        this.scaleInterval = interval / 10;
        eprint("Scaling from " + this.fromWidth + "x" + this.fromHeight + " to " + this.toWidth + "x" + this.toHeight);
    };
    
    this.timerUpdate = function(interval) {
        if (this.moving || this.fading || this.scaling) {
            if (this.moving) {
                if ((this.toX > this.fromX) && (this.hOffset < this.toX) ||
                    (this.toX < this.fromX) && (this.hOffset > this.toX) ||
                    (this.toY > this.fromY) && (this.vOffset < this.toY) ||
                    (this.toY < this.fromY) && (this.vOffset > this.toY)) {
                    this.hOffset += (this.toX - this.fromX) *
                        (interval / this.moveInterval);
                    this.vOffset += (this.toY - this.fromY) *
                        (interval / this.moveInterval);
                } else {
                    this.moving = false;
                }
            }
            
            if (this.fading) {
                if ((this.toOpacity > this.fromOpacity) && (this.opacity < this.toOpacity) ||
                    (this.toOpacity < this.fromOpacity) && (this.opacity > this.toOpacity)) {
                    this.opacity += (this.toOpacity - this.fromOpacity) *
                        (interval / this.fadeInterval);
                } else {
                    this.fading = false;
                }
            }
            
            if (this.scaling) {
                if ((this.toWidth > this.fromWidth) && (this.width < this.toWidth) ||
                    (this.toWidth < this.fromWidth) && (this.width > this.toWidth) ||
                    (this.toHeight > this.fromHeight) && (this.height < this.toHeight) ||
                    (this.toHeight < this.fromHeight) && (this.height > this.toHeight)) {
                    this.width += (this.toWidth - this.fromWidth) *
                        (interval / this.scaleInterval);
                    this.height += (this.toHeight - this.fromHeight) *
                        (interval / this.scaleInterval);
                } else {
                    this.scaling = false;
                }
            }
            
            this.updatePosition();
            this.setOpacity(this.opacity);
        }
    };
    
    this.updatePosition();
}